/* **************************************************************************************************** */
CREATE OR REPLACE FORCE VIEW w83b.w83bbusqbandejaentrada (preaviso_008,
                                                          f_entrada_007,
                                                          f_regis_008,
                                                          f_inicio_008,
                                                          raz_social_008,
                                                          cif_008,
                                                          prov_008,
                                                          munic_008,
                                                          estado_008,
                                                          descprovincia,
                                                          descmunicipio,
                                                          c_territ_008
                                                         )
AS
   SELECT preaviso_008, f_entrada_007, f_regis_008, f_inicio_008,
          raz_social_008, cif_008, prov_008, munic_008, estado_008,
          provincias.ds_o AS descprovincia, municipios.ds_o AS descmunicipio,
          c_territ_008
     FROM w83b08s00 preavisos INNER JOIN w83b07s00 lotes
          ON preavisos.lote_008 = lotes.lote_007
          LEFT OUTER JOIN t17i.t17_provincia provincias
          ON preavisos.prov_008 = provincias.ID
          LEFT OUTER JOIN t17i.t17_municipio municipios
          ON municipios.provincia_id = provincias.ID
        AND municipios.ID = preavisos.munic_008
    WHERE estado_008 <> 1 AND tipo_008 = 'I';
/
/* *************************************************************************************************** */
CREATE OR REPLACE FORCE VIEW w83b.w83bdetallepreavpendtram (raz_social_008,
                                                            domic_008,
                                                            c_territ_008,
                                                            munic_008,
                                                            codpos_008,
                                                            telefono_008,
                                                            fax_008,
                                                            email_008,
                                                            cnae_008,
                                                            f_inicio_008,
                                                            c_conv_008,
                                                            s_parcial_008,
                                                            global_008,
                                                            admonemp_008,
                                                            n_cenafec_008,
                                                            c_sindi_prom_008,
                                                            ident_008,
                                                            observ_008,
                                                            estado_008,
                                                            preaviso_008,
                                                            f_entrada_007,
                                                            desccnae,
                                                            cif_008,
                                                            lote_008,
                                                            n_regis_008,
                                                            prov_008,
                                                            n_preavisos_007,
                                                            tipo_008,
                                                            n_preaviso_008,
                                                            ano_preaviso_008,
                                                            f_regis_008,
                                                            c_sindi_007,
                                                            correl_007,
                                                            f_creacion_007,
                                                            tipo_iden_008,
                                                            th_ss_008,
                                                            n_ss_008,
                                                            ctrl_ss_008,
                                                            n_trabaj_008
                                                           )
AS
   SELECT raz_social_008, domic_008, c_territ_008, munic_008, codpos_008,
          telefono_008, fax_008, email_008, cnae_008, f_inicio_008,
          c_conv_008, s_parcial_008, global_008, admonemp_008, n_cenafec_008,
          c_sindi_prom_008, ident_008, observ_008, estado_008, preaviso_008,
          f_entrada_007, desccnae, cif_008, lote_008, n_regis_008, prov_008,
          n_preavisos_007, tipo_008, n_preaviso_008, ano_preaviso_008,
          f_regis_008, c_sindi_007, correl_007, f_creacion_007, tipo_iden_008,
          th_ss_008, n_ss_008, ctrl_ss_008, n_trabaj_008
     FROM w83b08s00 preavisos INNER JOIN w83b07s00 lotes
          ON preavisos.lote_008 = lotes.lote_007
          LEFT OUTER JOIN w83bcnae cnae ON preavisos.cnae_008 = cnae.idcnae
          ;
/
/* *************************************************************************************************** */
ALTER TABLE W83B08T00 ADD (TIPO_008 VARCHAR2(1) DEFAULT 'I');
/
/* *************************************************************************************************** */
COMMENT ON COLUMN W83B08T00.TIPO_008 IS 'I si es un preaviso del lote de IDA; V  si es un preaviso del lote de vuelta';
/
/* *************************************************************************************************** */
CREATE SEQUENCE W83B.SECUENCIAPREAVPENDTRAM
  START WITH 80
  MAXVALUE 999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;
/
/* *************************************************************************************************** */
ALTER TABLE W83B08T00 ADD (PROV_008 VARCHAR2(2));
/
/* *************************************************************************************************** */
COMMENT ON COLUMN W83B08T00.PROV_008 IS 'Provincia del centro de trabajo';
/
/* *************************************************************************************************** */